<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../classi/Lista.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $lista = new Lista($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $lista = new Lista($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $lista->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $lista->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $lista->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $lista->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_ADD_SLASHES));
            $lista->setIcona(filter_input(INPUT_POST,"icona",FILTER_SANITIZE_STRING));
            $lista->crea();
            header("Location: ../creaLista.php?id={$lista->getId()}&status=200");
            break;
        case 'modifica':
            $lista->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $lista->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $lista->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $lista->setTipoVisualizzazione(filter_input(INPUT_POST,"tipoVisualizzazione",FILTER_SANITIZE_STRING));
            $lista->setIcona(filter_input(INPUT_POST,"icona",FILTER_SANITIZE_STRING));
            $lista->modifica();
            header("Location: ../creaLista.php?id={$lista->getId()}&status=250");
            break;
        case 'elimina':
            $lista->elimina();
            echo "ok";
            break;
        case 'duplica':
            $lista->caricaDatiDalDatabase();
            $idNuovaForm = $lista->duplica();
            header("Location: ../creaLista.php?id={$idNuovaForm}&status=260");
            break;
        case 'stampaElementi':
            $lista->stampaElementi();
            break;
        case 'creaElemento':
            $lista->creaElemento(filter_input(INPUT_POST, "nome",FILTER_SANITIZE_ADD_SLASHES),filter_input(INPUT_POST, "descrizione",FILTER_SANITIZE_ADD_SLASHES));
            echo "ok";
            break;
        case 'spostaElemento':
            $lista->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome           = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $descrizione    = filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES);
            $classeELemento = filter_input(INPUT_POST,"classeElemento",FILTER_SANITIZE_STRING);
            
            $lista->modificaElemento($idElemento,$nome, $descrizione,$classeELemento);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'duplicaElemento':
            $idElementoDuplicato = $lista->duplicaElemento(filter_input(INPUT_GET, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$idElementoDuplicato}&status=220");
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/slider", 0, $categoria->getNome());
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $slider->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaElemento':
            $lista->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
